//
//  BIABPeoplePicker.h
//  BIViews
//
//  Created by Eric Hochmeister on 03/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCHelpController.h>

enum {
	BIABPeoplePickerDayliteCreateAndAddClient = 2,
	BIABPeoplePickerAddressBookAddClientToBillings = 3,
	BIABPeoplePickerQuickBooksAddClientToBillings = 4,
};

@class ABPerson, ABPeoplePickerView;
@class DayliteContactContainer;
@class BIDocument, BIClient;
@class BIQuickBooksCustomersView;

@interface BIABPeoplePicker : NSWindowController <NSOpenSavePanelDelegate>
{	
	IBOutlet NSPopUpButton *sourceChooserPopup;
	IBOutlet NSTabView *sourceTabview;	
	
	IBOutlet ABPeoplePickerView* _abPickerView;
	
	IBOutlet NSTableView *dayliteAddressesTV;
	IBOutlet NSArrayController *dayliteAddressesAC;
	IBOutlet NSSearchField *dayliteSearchField;
	IBOutlet NSTextField *dayliteResultsField;
    
	IBOutlet NSButton *doneButton;
	
	IBOutlet BIQuickBooksCustomersView *quickBooksCustomersView;
	
    DayliteContactContainer* contactContainer;
	BIClient* newClient;
	
	BIDocument *biDoc; // weak
    id _delegate; // weak
    
    void *sheetEndContextInfo;
    
	BOOL linkMode;
	ABPerson *linkPerson;
	
	ABPerson *newCardPerson;
}

@property (nonatomic) void *sheetEndContextInfo;

- (id)initWithDocument:(BIDocument *)biDocument withDelegate:(id)delegate;

- (void)setupForLinking;
- (ABPerson *)linkPerson;

// Actions

- (IBAction)done:(id)sender;
- (IBAction)cancel:(id)sender;

- (IBAction)newCard:(id)sender;
- (IBAction)help:(id)sender;

// Change Source

- (IBAction)changeToAddressBookSource:(id)sender;
- (IBAction)changeToDayliteSource:(id)sender;
- (IBAction)changeToQuickBooksSource:(id)sender;

// Daylite

- (IBAction)searchInDaylite:(id)sender;

// Misc

- (DayliteContactContainer*)contactContainer;
- (BIClient *)newClient;

@end
